/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.entity.butterfly;

import azmalent.cuneiform.lib.util.BiomeUtil;
import azmalent.terraincognita.TerraIncognita;
import azmalent.terraincognita.common.entity.butterfly.AbstractButterflyEntity;
import azmalent.terraincognita.common.entity.butterfly.ai.ButterflyLandOnFlowerGoal;
import azmalent.terraincognita.common.entity.butterfly.ai.ButterflyRestGoal;
import azmalent.terraincognita.common.entity.butterfly.ai.ButterflyWanderGoal;
import azmalent.terraincognita.common.registry.ModEntities;
import azmalent.terraincognita.common.registry.ModItems;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class ButterflyEntity
extends AbstractButterflyEntity {
    public static final DataParameter<Integer> BUTTERFLY_TYPE = EntityDataManager.func_187226_a(ButterflyEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> TIRED = EntityDataManager.func_187226_a(ButterflyEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> LANDED = EntityDataManager.func_187226_a(ButterflyEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final Predicate<LivingEntity> SHOULD_AVOID = entity -> {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        return !player.func_184812_l_() && !player.func_175149_v() && player.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() != ModItems.WREATH.get();
    };
    public ButterflyRestGoal restGoal;

    public boolean hasPlayersNearby() {
        return !this.field_70170_p.func_175647_a(PlayerEntity.class, this.func_174813_aQ().func_72321_a(4.0, 4.0, 4.0), SHOULD_AVOID).isEmpty();
    }

    public ButterflyEntity(EntityType<ButterflyEntity> type, World world) {
        super(type, world);
    }

    public ButterflyEntity(World world, double x, double y, double z) {
        super((EntityType<? extends AbstractButterflyEntity>)((EntityType)ModEntities.BUTTERFLY.get()), world);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public ButterflyEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super((EntityType<? extends AbstractButterflyEntity>)((EntityType)ModEntities.BUTTERFLY.get()), world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BUTTERFLY_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(TIRED, (Object)false);
        this.field_70180_af.func_187214_a(LANDED, (Object)false);
        this.field_70180_af.func_187214_a(SIZE_MODIFIER, (Object)Float.valueOf(0.7f));
    }

    @Override
    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74778_a("Type", this.getButterflyType().getName());
        tag.func_74757_a("IsTired", this.isTired());
        tag.func_74757_a("IsLanded", this.isLanded());
    }

    @Override
    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.setButterflyType(Type.getTypeByName(tag.func_74779_i("Type")));
        this.setTired(tag.func_74767_n("IsTired"));
        this.setLanded(tag.func_74767_n("IsLanded"));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 4.0f, 2.0, 2.4, SHOULD_AVOID));
        this.restGoal = new ButterflyRestGoal(this);
        this.field_70714_bg.func_75776_a(1, (Goal)this.restGoal);
        this.field_70714_bg.func_75776_a(2, (Goal)new ButterflyLandOnFlowerGoal(this, 2.4, 16));
        this.field_70714_bg.func_75776_a(3, (Goal)new ButterflyWanderGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new SwimGoal((MobEntity)this));
    }

    public static boolean canSpawn(EntityType<ButterflyEntity> butterfly, IWorld world, SpawnReason reason, BlockPos pos, Random randomIn) {
        return pos.func_177956_o() >= world.func_181545_F() && world.func_226659_b_(pos, 0) > 8;
    }

    public Type getButterflyType() {
        return Type.getTypeByIndex((Integer)this.field_70180_af.func_187225_a(BUTTERFLY_TYPE));
    }

    private void setButterflyType(Type type) {
        this.field_70180_af.func_187227_b(BUTTERFLY_TYPE, (Object)type.getIndex());
    }

    @Override
    protected float getRandomSizeModifier() {
        return this.getButterflyType().getRandomSize(this.field_70146_Z);
    }

    @Override
    public boolean isTired() {
        return (Boolean)this.field_70180_af.func_187225_a(TIRED);
    }

    public void setTired(boolean tired) {
        this.field_70180_af.func_187227_b(TIRED, (Object)tired);
    }

    @Override
    public boolean isLanded() {
        return (Boolean)this.field_70180_af.func_187225_a(LANDED);
    }

    public void setLanded(boolean landed) {
        this.field_70180_af.func_187227_b(LANDED, (Object)landed);
    }

    public void setNotLanded() {
        this.setLanded(false);
        this.func_70634_a((double)this.func_233580_cy_().func_177958_n() + 0.5, (double)this.func_233580_cy_().func_177956_o() + 0.5, (double)this.func_233580_cy_().func_177952_p() + 0.5);
    }

    @Override
    public float getWingRotation(float ageInTicks) {
        if (this.isLanded() && this.func_213322_ci().func_189985_c() < 1.0E-7) {
            if (this.field_70170_p.func_72935_r() && this.field_70146_Z.nextInt(100) == 0) {
                this.targetWingRotation = this.field_70146_Z.nextFloat();
            }
            this.wingRotation = MathHelper.func_219799_g((float)0.05f, (float)this.wingRotation, (float)this.targetWingRotation);
        } else {
            this.wingRotation = MathHelper.func_76135_e((float)MathHelper.func_76134_b((float)(ageInTicks / 1.5f)));
        }
        return this.wingRotation;
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.isLanded()) {
            this.flyingTicks = 0;
            this.func_213317_d(Vector3d.field_186680_a);
        } else {
            ++this.flyingTicks;
            if (this.flyingTicks > 600 && this.func_70681_au().nextInt(200) == 0) {
                this.setTired(true);
            }
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.8, 1.0));
        }
    }

    public boolean func_70097_a(@Nonnull DamageSource damageSource, float damage) {
        boolean damaged = super.func_70097_a(damageSource, damage);
        if (damaged && this.isLanded()) {
            this.setNotLanded();
        }
        return damaged;
    }

    @Override
    public ResourceLocation getTexture() {
        return this.getButterflyType().getTexture();
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        RegistryKey biomeKey = BiomeUtil.getBiomeKey((IWorldReader)worldIn, (BlockPos)this.func_233580_cy_());
        Type type = Type.getRandomType((RegistryKey<Biome>)biomeKey, worldIn.func_201674_k());
        this.setButterflyType(type);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ModItems.BUTTERFLY_SPAWN_EGG.get());
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type PEACOCK = new Type(0, "peacock", 0.6f, 0.15f);
        public static final /* enum */ Type BRIMSTONE = new Type(1, "brimstone", 0.5f, 0.1f);
        public static final /* enum */ Type CABBAGE_WHITE = new Type(2, "cabbage_white", 0.6f, 0.15f);
        public static final /* enum */ Type COMMON_BLUE = new Type(3, "common_blue", 0.5f, 0.1f);
        public static final /* enum */ Type ORANGE_TIP = new Type(4, "orange_tip", 0.5f, 0.15f);
        public static final /* enum */ Type MONARCH = new Type(5, "monarch", 0.6f, 0.2f);
        private static final Type[] VALUES;
        private static final Map<String, Type> TYPES_BY_NAME;
        private final int index;
        private final String name;
        private final ResourceLocation texture;
        private final float averageSize;
        private final float sizeVariation;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(int index, String name, float averageSize, float sizeVariation) {
            assert (averageSize >= sizeVariation);
            this.index = index;
            this.name = name;
            this.texture = TerraIncognita.prefix("textures/entity/butterfly/" + name + ".png");
            this.averageSize = averageSize;
            this.sizeVariation = sizeVariation;
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public float getRandomSize(Random random) {
            return MathHelper.func_219799_g((float)random.nextFloat(), (float)(this.averageSize - this.sizeVariation), (float)(this.averageSize + this.sizeVariation));
        }

        public static Type getTypeByName(String nameIn) {
            return TYPES_BY_NAME.getOrDefault(nameIn, PEACOCK);
        }

        public static Type getTypeByIndex(int indexIn) {
            if (indexIn < 0 || indexIn > VALUES.length) {
                indexIn = 0;
            }
            return VALUES[indexIn];
        }

        public static Type getRandomType(RegistryKey<Biome> biome, Random random) {
            return (Type)((Object)Util.func_240989_a_((Object[])VALUES, (Random)random));
        }

        static {
            $VALUES = new Type[]{PEACOCK, BRIMSTONE, CABBAGE_WHITE, COMMON_BLUE, ORANGE_TIP, MONARCH};
            VALUES = (Type[])Arrays.stream(Type.values()).sorted(Comparator.comparingInt(Type::getIndex)).toArray(Type[]::new);
            TYPES_BY_NAME = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getName, name -> name));
        }
    }
}

